/*
 * Decompiled with CFR 0.152.
 */
package fuzs.spikyspikes;

import fuzs.puzzleslib.core.CoreServices;
import fuzs.spikyspikes.SpikySpikes;
import fuzs.spikyspikes.data.ModBlockStateProvider;
import fuzs.spikyspikes.data.ModBlockTagsProvider;
import fuzs.spikyspikes.data.ModItemModelProvider;
import fuzs.spikyspikes.data.ModLanguageProvider;
import fuzs.spikyspikes.data.ModLootTableProvider;
import fuzs.spikyspikes.data.ModRecipeProvider;
import fuzs.spikyspikes.handler.ItemCombinerHandler;
import fuzs.spikyspikes.handler.SpikeLootHandler;
import fuzs.spikyspikes.init.ForgeModRegistry;
import java.util.Optional;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.util.Unit;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;

@Mod(value="spikyspikes")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SpikySpikesForge {
    @SubscribeEvent
    public static void onConstructMod(FMLConstructModEvent evt) {
        CoreServices.FACTORIES.modConstructor("spikyspikes").accept(new SpikySpikes());
        ForgeModRegistry.touch();
        SpikySpikesForge.registerHandlers();
    }

    private static void registerHandlers() {
        MinecraftForge.EVENT_BUS.addListener(evt -> SpikeLootHandler.onLootingLevel(evt.getEntity(), evt.getDamageSource(), evt.getLootingLevel()).ifPresent(arg_0 -> ((LootingLevelEvent)evt).setLootingLevel(arg_0)));
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            MutableObject output = new MutableObject((Object)evt.getOutput());
            MutableInt cost = new MutableInt(evt.getCost());
            MutableInt materialCost = new MutableInt(evt.getMaterialCost());
            Optional<Unit> result = ItemCombinerHandler.onAnvilUpdate(evt.getLeft(), evt.getRight(), (MutableObject<ItemStack>)output, evt.getName(), cost, materialCost, evt.getPlayer());
            if (result.isPresent()) {
                evt.setCanceled(true);
            } else {
                evt.setOutput((ItemStack)output.getValue());
                evt.setCost(cost.intValue());
                evt.setMaterialCost(materialCost.intValue());
            }
        });
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent evt) {
        DataGenerator generator = evt.getGenerator();
        ExistingFileHelper existingFileHelper = evt.getExistingFileHelper();
        generator.m_236039_(true, (DataProvider)new ModLootTableProvider(generator, "spikyspikes"));
        generator.m_236039_(true, (DataProvider)new ModRecipeProvider(generator, "spikyspikes"));
        generator.m_236039_(true, (DataProvider)new ModBlockTagsProvider(generator, "spikyspikes", existingFileHelper));
        generator.m_236039_(true, (DataProvider)new ModLanguageProvider(generator, "spikyspikes"));
        generator.m_236039_(true, (DataProvider)new ModBlockStateProvider(generator, "spikyspikes", existingFileHelper));
        generator.m_236039_(true, (DataProvider)new ModItemModelProvider(generator, "spikyspikes", existingFileHelper));
    }
}

